#############################################################################
# LFS Lapper Multi-Page Help System by Krayy
#############################################################################
# This is a more flexible Help system that allows the addition of extra help
# descriptions without encroaching on available screen area.
#############################################################################
# Ver 1.0.1 - 15 Jan 2010 Initial release
# Ver 1.0.2 - 16 Jan 2010 Minor updates to display
# Ver 1.0.4 - 16 Feb 2010 Updated to support v 5.926b
# Ver 1.0.5 - 7 July 2010, Updated for common look & feel interface
#############################################################################

CatchEvent OnLapperStart()
	# CifRegisterModule("Group_Name", "Module Name", MODULE_VERSION);
	CifRegisterModule("Help", "Custom", "1.01");
EndCatchEvent

Sub DoCifHelpCustom ( $KeyFlags, $id )
	# Set default values for the module - these MUST be the same as the main Do function name
	$cifGroupName="Help";
	$cifModuleName="Custom";
	$DialogPrefix = "CIF" . $cifGroupName . $cifModuleName . "_";

	# Draw the CIF dialog box
	CifDraw($cifGroupName, $cifModuleName, "Custom Help");
	openPrivButton ( $DialogPrefix . "help",$CifOrigL+1,$CifOrigT,98,6,5,-1,64,langEngine( "%{gui_help_contents_" . $cifModuleName . "}%") );
EndSub

Lang "EN" # Race Events messages
	gui_help_contents_Custom = "^2Custom Commands"
			. "%nl%^3!event ^8- Set up race event"
			. "%nl%^3!ma ^8- Configure server Membership"
			. "%nl%^3!sc ^8- Deploy or Manage Safety Car";
EndLang
